package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties({"dispLastRefreshed", "numAdmins"})
public class StudyApprovalCountDTO implements Serializable {

	private static final long serialVersionUID = -112652092184013502L;
	
	private Date lastRefreshed;
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd@HH:mm:ss.SSSZ")
	private Date dispLastRefreshed;
	private long totalStudyApproval;
	private long numRequesters;
	/**
	 * @return the lastRefreshed
	 */
	public Date getLastRefreshed() {
		return lastRefreshed;
	}
	/**
	 * @param lastRefreshed the lastRefreshed to set
	 */
	public void setLastRefreshed(Date lastRefreshed) {
		this.lastRefreshed = lastRefreshed;
	}
	/**
	 * @return the dispLastRefreshed
	 */
	public Date getDispLastRefreshed() {
		return dispLastRefreshed;
	}
	/**
	 * @param dispLastRefreshed the dispLastRefreshed to set
	 */
	public void setDispLastRefreshed(Date dispLastRefreshed) {
		this.dispLastRefreshed = dispLastRefreshed;
	}
	
	/**
	 * @return the numRequesters
	 */
	public long getNumRequesters() {
		return numRequesters;
	}
	/**
	 * @param numRequesters the numRequesters to set
	 */
	public void setNumRequesters(long numRequesters) {
		this.numRequesters = numRequesters;
	}
	/**
	 * @return the totalStudyApproval
	 */
	public long getTotalStudyApproval() {
		return totalStudyApproval;
	}
	/**
	 * @param totalStudyApproval the totalStudyApproval to set
	 */
	public void setTotalStudyApproval(long totalStudyApproval) {
		this.totalStudyApproval = totalStudyApproval;
	}
}
